unit fSiteParam;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls, ORNet, ORFn, ExtCtrls, ORCtrls;

type
  TfrmSiteParam = class(TForm)
    pnl1: TPanel;
    btnSave: TButton;
    btnExit: TBitBtn;
    pcSite: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    btnFInact: TButton;
    btnFEdit: TButton;
    btnFAdd: TButton;
    lbFac: TORListBox;
    lblFac: TLabel;
    rgPos: TKeyClickRadioGroup;
    cbFUser: TORComboBox;
    lblFUser: TLabel;
    btnMAdd: TButton;
    btnMInact: TButton;
    lbMan: TORListBox;
    lblMan: TLabel;
    lblSched: TLabel;
    edSched: TEdit;
    lblAM: TLabel;
    lblLocal: TLabel;
    TabSheet4: TTabSheet;
    lblAnes: TLabel;
    lbAnes: TORListBox;
    btnAAdd: TButton;
    btnAInact: TButton;
    TabSheet5: TTabSheet;
    TabSheet6: TTabSheet;
    lblIssue: TLabel;
    lbIssue: TORListBox;
    btnIAdd: TButton;
    btnIInact: TButton;
    lblTask: TLabel;
    lbTask: TORListBox;
    btnTAdd: TButton;
    btnTInact: TButton;
    btnTEdit: TButton;
    btnIEdit: TButton;
    cbFSpec: TORComboBox;
    lblFSpec: TLabel;
    lbFSpec: TORListBox;
    lblAssign: TLabel;
    btnSAdd: TButton;
    btnSDel: TButton;
    lbFTemp: TORListBox;
    TabSheet7: TTabSheet;
    lbSSpec: TORListBox;
    lblSSpec: TLabel;
    btnSpAdd: TButton;
    btnSInact: TButton;
    pnlSSel: TPanel;
    lblSSel: TLabel;
    cbSSpec: TORComboBox;
    lblSServ: TLabel;
    cbSServ: TORComboBox;
    btnSOK: TButton;
    btnSCanc: TButton;
    pnlTSel: TPanel;
    lblTSelect: TLabel;
    edTask: TEdit;
    lblTSpec: TLabel;
    cbTSpec: TORComboBox;
    btnTOK: TButton;
    btnTCanc: TButton;
    TabSheet8: TTabSheet;
    lblField: TLabel;
    cb1: TCheckBox;
    cb2: TCheckBox;
    cb3: TCheckBox;
    cb4: TCheckBox;
    cb5: TCheckBox;
    cb6: TCheckBox;
    cb7: TCheckBox;
    cb8: TCheckBox;
    cb9: TCheckBox;
    cb10: TCheckBox;
    cb11: TCheckBox;
    cb12: TCheckBox;
    cb13: TCheckBox;
    cb14: TCheckBox;
    cb15: TCheckBox;
    cb16: TCheckBox;
    cb17: TCheckBox;
    cb18: TCheckBox;
    cb19: TCheckBox;
    cb20: TCheckBox;
    cb21: TCheckBox;
    cb22: TCheckBox;
    cb23: TCheckBox;
    cb24: TCheckBox;
    cb25: TCheckBox;
    cb26: TCheckBox;
    cb27: TCheckBox;
    cb28: TCheckBox;
    cb29: TCheckBox;
    cb30: TCheckBox;
    lblTime: TLabel;
    edTime: TEdit;
    UpDownTime: TUpDown;
    lblMin: TLabel;
    lblMatch: TLabel;
    lblMatch1: TLabel;
    lblMatch2: TLabel;
    lblMatch3: TLabel;
    cbAdmin: TORComboBox;
    cbDeceased: TORComboBox;
    cbOut: TORComboBox;
    lbSite: TORListBox;
    lblFrom: TLabel;
    cbFrom: TORComboBox;
    pnlISel: TPanel;
    edIssue: TEdit;
    lblSelect: TLabel;
    btnIOK: TButton;
    btnICanc: TButton;
    pnlMSel: TPanel;
    lblMUser: TLabel;
    cbMUser: TORComboBox;
    btnMCanc: TButton;
    pnlASel: TPanel;
    lblAUser: TLabel;
    cbAUser: TORComboBox;
    btnACanc: TButton;
    lblConsult: TLabel;
    cbLocY: TCheckBox;
    cbLocN: TCheckBox;
    cbConY: TCheckBox;
    cbConN: TCheckBox;
    procedure btnSaveClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure btnMAddClick(Sender: TObject);
    procedure btnFAddClick(Sender: TObject);
    procedure lbManClick(Sender: TObject);
    procedure lbFacClick(Sender: TObject);
    procedure cbFUserClick(Sender: TObject);
    procedure DisplayMUser;
    procedure HideMUser;
    procedure DisplayFUser;
    procedure HideFUser;
    procedure rgPosClick(Sender: TObject);
    procedure btnMInactClick(Sender: TObject);
    procedure btnFInactClick(Sender: TObject);
    procedure edSchedChange(Sender: TObject);
    procedure lbManChange(Sender: TObject);
    procedure lbFacChange(Sender: TObject);
    procedure btnFEditClick(Sender: TObject);
    procedure cbMUserClick(Sender: TObject);
    procedure rbLocYClick(Sender: TObject);
    procedure rbLocNClick(Sender: TObject);
    procedure HideAUser;
    procedure DisplayAUser;
    procedure btnAAddClick(Sender: TObject);
    procedure btnAInactClick(Sender: TObject);
    procedure cbAUserClick(Sender: TObject);
    procedure lbAnesChange(Sender: TObject);
    procedure lbAnesClick(Sender: TObject);
    procedure cbMUserChange(Sender: TObject);
    procedure cbFUserChange(Sender: TObject);
    procedure cbAUserChange(Sender: TObject);
    procedure btnIAddClick(Sender: TObject);
    procedure lbIssueClick(Sender: TObject);
    procedure btnIInactClick(Sender: TObject);
    procedure HideTask;
    procedure lbTaskClick(Sender: TObject);
    procedure btnTEditClick(Sender: TObject);
    procedure DisplayTask;
    procedure btnTAddClick(Sender: TObject);
    procedure cbTSpecChange(Sender: TObject);
    procedure btnTInactClick(Sender: TObject);
    procedure edTaskChange(Sender: TObject);
    procedure cbTSpecClick(Sender: TObject);
    procedure btnIEditClick(Sender: TObject);
    procedure btnSAddClick(Sender: TObject);
    procedure cbFSpecClick(Sender: TObject);
    procedure DisplayFUser2;
    procedure btnSDelClick(Sender: TObject);
    procedure HideSSpec;
    procedure DisplaySSpec;
    procedure btnSpAddClick(Sender: TObject);
    procedure lbSSpecClick(Sender: TObject);
    procedure cbSSpecChange(Sender: TObject);
    procedure btnSInactClick(Sender: TObject);
    procedure cbSServChange(Sender: TObject);
    procedure btnSOKClick(Sender: TObject);
    procedure btnSCancClick(Sender: TObject);
    procedure btnTCancClick(Sender: TObject);
    procedure btnTOKClick(Sender: TObject);
    procedure pcSiteChange(Sender: TObject);
    procedure cb1Click(Sender: TObject);
    procedure cb2Click(Sender: TObject);
    procedure cb3Click(Sender: TObject);
    procedure cb4Click(Sender: TObject);
    procedure cb5Click(Sender: TObject);
    procedure cb6Click(Sender: TObject);
    procedure cb7Click(Sender: TObject);
    procedure cb8Click(Sender: TObject);
    procedure cb9Click(Sender: TObject);
    procedure cb10Click(Sender: TObject);
    procedure cb11Click(Sender: TObject);
    procedure cb12Click(Sender: TObject);
    procedure cb13Click(Sender: TObject);
    procedure cb14Click(Sender: TObject);
    procedure cb15Click(Sender: TObject);
    procedure cb16Click(Sender: TObject);
    procedure cb17Click(Sender: TObject);
    procedure cb18Click(Sender: TObject);
    procedure cb19Click(Sender: TObject);
    procedure cb20Click(Sender: TObject);
    procedure cb21Click(Sender: TObject);
    procedure cb22Click(Sender: TObject);
    procedure cb23Click(Sender: TObject);
    procedure cb24Click(Sender: TObject);
    procedure cb25Click(Sender: TObject);
    procedure cb26Click(Sender: TObject);
    procedure cb27Click(Sender: TObject);
    procedure cb28Click(Sender: TObject);
    procedure cb29Click(Sender: TObject);
    procedure cb30Click(Sender: TObject);
    procedure cbSServClick(Sender: TObject);
    procedure cbAdminChange(Sender: TObject);
    procedure cbAdminClick(Sender: TObject);
    procedure cbDeceasedChange(Sender: TObject);
    procedure cbDeceasedClick(Sender: TObject);
    procedure cbOutChange(Sender: TObject);
    procedure cbOutClick(Sender: TObject);
    procedure edTimeChange(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure cbFromChange(Sender: TObject);
    procedure cbFromClick(Sender: TObject);
    procedure RequiredFields;
    procedure HideIssue;
    procedure DisplayIssue;
    procedure btnICancClick(Sender: TObject);
    procedure btnIOKClick(Sender: TObject);
    procedure btnMCancClick(Sender: TObject);
    procedure btnACancClick(Sender: TObject);
    procedure lbFSpecClick(Sender: TObject);
    procedure cbConYClick(Sender: TObject);
    procedure cbConNClick(Sender: TObject);
    procedure cbLocYClick(Sender: TObject);
    procedure cbLocNClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmSiteParam: TfrmSiteParam;
  Rdata, parlist, Itemp, Ttemp, Stemp: string;
  Change, Edit, IEdit, TEdit, FClick, PClick: integer;
  Tab1, Tab2, Tab3, Tab4, Tab5, Tab6, Tab7, Tab8: integer;
  AdmIFN, DecIFN, OutIFN, FromIFN, ServIFN: string;

procedure SiteParam;

implementation

{$R *.dfm}

uses SCMMain, rLocal;

procedure SiteParam;
begin
  frmSiteParam := TfrmSiteParam.Create(Application);
  with frmSiteParam do
  begin
    CallV('APTWL GET SITE PARAM', [SiteIFN]);
    lbSite.Items := RPCBrokerV.Results;
    Caption := Caption + ' for ' + piece(lbSite.Items[1], '^', 2);
    edSched.Text := lbSite.Items[2];
    if lbSite.Items[3] = '1' then cbLocY.Checked  := True;
    if lbSite.Items[3] = '0' then cbLocN.Checked  := True;
    if lbSite.Items[11] = '1' then cbConY.Checked := True;
    if lbSite.Items[11] = '0' then cbConN.Checked := True;
    if UserSite = 648 then
      begin
        lblLocal.Visible := False;
        cbLocY.Visible   := False;
        cbLocN.Visible   := False;
      end;
    UpDownTime.Position := StrToInt(lbSite.Items[6]);
    cbAdmin.Text    := piece(lbSite.Items[7], '^', 2);
    AdmIFN          := piece(lbSite.Items[7], '^', 1);
    cbDeceased.Text := piece(lbSite.Items[8], '^', 2);
    DecIFN          := piece(lbSite.Items[8], '^', 1);
    cbOut.Text      := piece(lbSite.Items[9], '^', 2);
    OutIFN          := piece(lbSite.Items[9], '^', 1);
    cbFrom.Text     := piece(lbSite.Items[10], '^', 2);
    FromIFN         := piece(lbSite.Items[10], '^', 1);
    CallV('APTWL GET MANAGERS', [SiteIFN]);
    lbMan.Items  := RPCBrokerV.Results;
    CallV('APTWL GET FACILITATORS', [SiteIFN]);
    lbFac.Items  := RPCBrokerV.Results;
    CallV('APTWL GET ANES', [SiteIFN]);
    lbAnes.Items  := RPCBrokerV.Results;
    CallV('APTWL GET ISSUE LIST', []);
    lbIssue.Items  := RPCBrokerV.Results;
    CallV('APTWL GET TASK LIST', []);
    lbTask.Items  := RPCBrokerV.Results;
    CallV('APTWL GET USE SPEC', [SiteIFN]);
    lbSSpec.Items := RPCBrokerV.Results;
    CallV('APTWL GET CANCEL REASON', []);
    cbAdmin.Items := RPCBrokerV.Results;
    cbDeceased.Items := RPCBrokerV.Results;
    cbOut.Items   := RPCBrokerV.Results;
    CallV('APTWL GET HOSP LOC', []);
    cbFrom.Items  := RPCBrokerV.Results;
    RequiredFields;
    btnMInact.Enabled := False;
    btnFInact.Enabled := False;
    btnAInact.Enabled := False;
    btnIInact.Enabled := False;
    btnIEdit.Enabled  := False;
    btnTInact.Enabled := False;
    btnFEdit.Enabled  := False;
    btnTEdit.Enabled  := False;
    btnSInact.Enabled := False;
    btnSDel.Enabled   := False;
    HideMUser;
    HideFUser;
    HideAUser;
    HideTask;
    HideSSpec;
    Change := 0;
    Edit   := 0;
    IEdit  := 0;
    TEdit  := 0;
    Tab1   := 0;
    Tab2   := 0;
    Tab3   := 0;
    Tab4   := 0;
    Tab5   := 0;
    Tab6   := 0;
    Tab7   := 0;
    Tab8   := 0;
    FClick := 0;
    PClick := 1;
    if UserSite <> 648 then
      begin
        cb18.Enabled := False;
        cb23.Enabled := False;
        cb26.Enabled := False;
      end;
    pcSite.ActivePage := TabSheet1;
    ShowModal;
  end;
  frmSiteParam.Release;
end;


procedure TfrmSiteParam.btnSaveClick(Sender: TObject);
var
  Success, Local, Sdata, Match: string;
begin
  if Change = 0 then
    begin
      MessageDlg('No changes have been made.', mtInformation, [mbOK], 0);
      Exit;
    end;
  Local := '0';
  Match := '0';
  if (cbLocY.Checked = True) then Local := '1';
  if (cbLocN.Checked = True) then Local := '0';
  if (cbConY.Checked = True) then Match := '1';
  if (cbConN.Checked = True) then Match := '0';
  Sdata := '^' + edSched.Text + '^' + Local + '^^^' + edTime.Text + '^' + AdmIFN + '^' + DecIFN + '^' + OutIFN + '^' + FromIFN + '^' + Match;
  Rdata := BoolToStr(cb1.Checked) + '^' + BoolToStr(cb2.Checked) + '^' + BoolToStr(cb3.Checked) + '^' + BoolToStr(cb4.Checked) + '^' + BoolToStr(cb5.Checked);
  Rdata := Rdata + '^' + BoolToStr(cb6.Checked) + '^' + BoolToStr(cb7.Checked) + '^' + BoolToStr(cb8.Checked) + '^' + BoolToStr(cb9.Checked) + '^' + BoolToStr(cb10.Checked);
  Rdata := Rdata + '^' + BoolToStr(cb11.Checked) + '^' + BoolToStr(cb12.Checked) + '^' + BoolToStr(cb13.Checked) + '^' + BoolToStr(cb14.Checked) + '^' + BoolToStr(cb15.Checked);
  Rdata := Rdata + '^' + BoolToStr(cb16.Checked) + '^' + BoolToStr(cb17.Checked) + '^' + BoolToStr(cb18.Checked) + '^' + BoolToStr(cb19.Checked) + '^' + BoolToStr(cb20.Checked);
  Rdata := Rdata + '^' + BoolToStr(cb21.Checked) + '^' + BoolToStr(cb22.Checked) + '^' + BoolToStr(cb23.Checked) + '^' + BoolToStr(cb24.Checked) + '^' + BoolToStr(cb25.Checked);
  Rdata := Rdata + '^' + BoolToStr(cb26.Checked) + '^' + BoolToStr(cb27.Checked) + '^' + BoolToStr(cb28.Checked) + '^' + BoolToStr(cb29.Checked) + '^' + BoolToStr(cb30.Checked);
  Success := sCallV('APTWL PUT SITE PARAM', [Sdata, lbMan.Items, lbFac.Items, lbAnes.Items, lbIssue.Items, lbTask.Items, lbSSpec.Items, Rdata, SiteIFN]);
  if Success = '0' then
    begin
      MessageDlg('Saving Site Parameters was not successful.', mtwarning, [mbOK], 0);
      Exit;
    end;
  // update session parameters
  UsePTLD  := StrToInt(Local);
  ConMatch := StrToInt(Match);
  if frmSCMMain.TimeOut.Interval <> (StrToInt(edTime.Text) * 60000) then
    begin
      frmSCMMain.TimeOut.Interval := (StrToInt(edTime.Text) * 60000);
      ResetTimeOut;
    end;
  Close;
end;

procedure TfrmSiteParam.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmSiteParam.btnMAddClick(Sender: TObject);
begin
  DisplayMUser;
end;

procedure TfrmSiteParam.btnFAddClick(Sender: TObject);
begin
  DisplayFUser2;
  rgPos.Visible     := True;
  btnFEdit.Enabled  := False;
  btnFInact.Enabled := False;
end;

procedure TfrmSiteParam.lbManClick(Sender: TObject);
begin
  btnMInact.Enabled := True;
end;

procedure TfrmSiteParam.lbFacClick(Sender: TObject);
begin
  btnFInact.Enabled := True;
  btnFEdit.Enabled  := True;
  DisplayFUser;
  lblAssign.Caption := 'Assigned Specialties - ' + piece(piece(lbFac.Items[lbFac.ItemIndex], '^', 2), ',', 1);
  CallV('APTWL GET ASSIGNED SPEC', [piece(lbFac.Items[lbFac.ItemIndex], '^', 1), SiteIFN]);
  lbFSpec.Items := RPCBrokerV.Results;
end;

procedure TfrmSiteParam.cbFUserClick(Sender: TObject);
begin
  Edit := 0;
  rgPos.Enabled   := True;
  rgPos.ItemIndex := -1;
  Change := 1;
  FClick := 1;
end;

procedure TfrmSiteParam.DisplayFUser;
begin
  lblAssign.Visible := True;
  lbFSpec.Visible   := True;
  btnSAdd.Visible   := True;
  btnSDel.Visible   := True;
  btnFEdit.Enabled  := True;
  btnFInact.Enabled := True;
end;

procedure TfrmSiteParam.DisplayFUser2;
begin
  lblFUser.Visible := True;
  cbFUser.Visible  := True;
end;

procedure TfrmSiteParam.HideFUser;
begin
  lblFUser.Visible  := False;
  cbFUser.Visible   := False;
  rgPos.Visible     := False;
  lblFSpec.Visible  := False;
  cbFSpec.Visible   := False;
  btnFEdit.Enabled  := False;
  btnFInact.Enabled := False;
end;

procedure TfrmSiteParam.DisplayMUser;
begin
  pnlMSel.Visible   := True;
  btnMInact.Enabled := False;
end;

procedure TfrmSiteParam.HideMUser;
begin
  pnlMSel.Visible := False;
end;

procedure TfrmSiteParam.HideTask;
begin
  pnlTSel.Visible := False;
  btnTAdd.Enabled  := True;
  btnTEdit.Enabled := False;
end;

procedure TfrmSiteParam.DisplayTask;
begin
  pnlTSel.Visible := True;
end;

procedure TfrmSiteParam.rgPosClick(Sender: TObject);
var
  data, datax: string;
begin
  if PClick = 0 then Exit;
  if Edit = 0 then
    begin
      data := IntToStr(cbFUser.ItemIEN) + '^' + piece(cbFUser.Items[cbFUser.ItemIndex], '^', 2) + '^' + IntToStr(rgPos.ItemIndex + 1) + '^' + rgPos.Items[rgPos.ItemIndex];
      lbFac.Items.Add(data);
      cbFUser.Text     := '';
      //lblFUser.Enabled := False;
      //cbFUser.Enabled  := False;
    end;
  if Edit = 1 then
    begin
      datax := lbFac.Items[lbFac.ItemIndex];
      SetPiece(datax, '^', 3, IntToStr(rgPos.ItemIndex + 1));
      SetPiece(datax, '^', 4, rgPos.Items[rgPos.ItemIndex]);
      lbFac.Items[lbFac.ItemIndex] := datax;
    end;
  //rgPos.Enabled := False;
  Change := 1;
end;

procedure TfrmSiteParam.btnMInactClick(Sender: TObject);
begin
  if MessageDlg('Are you sure you want to inactivate ' + piece(lbMan.Items[lbMan.ItemIndex], '^', 2) + '?',
    mtConfirmation, [mbYes, mbNo], 0) = mrNo then Exit;
  lbMan.Items[lbMan.ItemIndex] := lbMan.Items[lbMan.ItemIndex] + '^Inactive';
  btnMInact.Enabled := False;
  Change := 1;
end;

procedure TfrmSiteParam.btnFInactClick(Sender: TObject);
begin
  if MessageDlg('Are you sure you want to inactivate ' + piece(lbFac.Items[lbFac.ItemIndex], '^', 2) + '?',
    mtConfirmation, [mbYes, mbNo], 0) = mrNo then Exit;
  lbFac.Items[lbFac.ItemIndex] := lbFac.Items[lbFac.ItemIndex] + '^Inactive';
  btnFInact.Enabled := False;
  Change := 1;
end;

procedure TfrmSiteParam.edSchedChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.lbManChange(Sender: TObject);
begin
  //Change := 1;
end;

procedure TfrmSiteParam.lbFacChange(Sender: TObject);
begin
  //Change := 1;
end;

procedure TfrmSiteParam.btnFEditClick(Sender: TObject);
var
  Pos: string;
begin
  PClick           := 0;
  rgPos.Visible    := True;
  Pos := piece(lbFac.Items[lbFac.ItemIndex], '^', 3);
  if Pos <> '' then rgPos.ItemIndex := (StrToInt(Pos) - 1);
  PClick           := 1;
  lblFUser.Visible := False;
  cbFUser.Visible  := False;
  btnFAdd.Enabled  := False;
  btnFInact.Enabled := False;
  Edit             := 1;
end;

procedure TfrmSiteParam.cbMUserClick(Sender: TObject);
var
  data: string;
begin
  data := IntToStr(cbMUser.ItemIEN) + '^' + piece(cbMUser.Items[cbMUser.ItemIndex], '^', 2);
  lbMan.Items.Add(data);
  cbMUser.Text     := '';
  HideMUser;
  Change := 1;
end;

procedure TfrmSiteParam.rbLocYClick(Sender: TObject);
begin
  Change  := 1;
end;

procedure TfrmSiteParam.rbLocNClick(Sender: TObject);
begin
  Change  := 1;
end;

procedure TfrmSiteParam.HideAUser;
begin
  pnlASel.Visible := False;
end;

procedure TfrmSiteParam.DisplayAUser;
begin
  pnlASel.Visible   := True;
  btnAInact.Enabled := False;
end;

procedure TfrmSiteParam.btnAAddClick(Sender: TObject);
begin
  DisplayAUser;
end;

procedure TfrmSiteParam.btnAInactClick(Sender: TObject);
begin
  if MessageDlg('Are you sure you want to inactivate ' + piece(lbAnes.Items[lbAnes.ItemIndex], '^', 2) + '?',
    mtConfirmation, [mbYes, mbNo], 0) = mrNo then Exit;
  lbAnes.Items[lbAnes.ItemIndex] := lbAnes.Items[lbAnes.ItemIndex] + '^Inactive';
  btnAInact.Enabled := False;
  Change := 1;
end;

procedure TfrmSiteParam.cbAUserClick(Sender: TObject);
var
  data: string;
begin
  data := IntToStr(cbAUser.ItemIEN) + '^' + piece(cbAUser.Items[cbAUser.ItemIndex], '^', 2);
  lbAnes.Items.Add(data);
  cbAUser.Text     := '';
  HideAUser;
  Change           := 1;
end;

procedure TfrmSiteParam.lbAnesChange(Sender: TObject);
begin
  //Change := 1;
end;

procedure TfrmSiteParam.lbAnesClick(Sender: TObject);
begin
  btnAInact.Enabled := True;
end;

procedure TfrmSiteParam.cbMUserChange(Sender: TObject);
begin
  if cbMUser.Text = '' then Exit;
  CallV('APTWL GET USERS', [cbMUser.Text]);
  cbMUser.Items := RPCBrokerV.Results;
  cbMUser.DroppedDown := True;
end;

procedure TfrmSiteParam.cbFUserChange(Sender: TObject);
begin
  if cbFUser.Text = '' then Exit;
  if FClick = 1 then
    begin
      FClick := 0;
      Exit;
    end;
  CallV('APTWL GET USERS', [cbFuser.Text]);
  cbFUser.Items := RPCBrokerV.Results;
  cbFUser.DroppedDown := True;
end;

procedure TfrmSiteParam.cbAUserChange(Sender: TObject);
begin
  if cbAUser.Text = '' then Exit;
  CallV('APTWL GET PROVIDER', ['G', 0, cbAUser.Text]);
  cbAUser.Items := RPCBrokerV.Results;
  cbAUser.DroppedDown := True;
end;

procedure TfrmSiteParam.btnIAddClick(Sender: TObject);
begin
  btnIEdit.Enabled  := False;
  btnIInact.Enabled := False;
  DisplayIssue;
end;

procedure TfrmSiteParam.lbIssueClick(Sender: TObject);
begin
  btnIInact.Enabled := True;
  btnIEdit.Enabled  := True;
end;

procedure TfrmSiteParam.btnIInactClick(Sender: TObject);
begin
  if MessageDlg('Are you sure you want to inactivate the' + CRLF +
    piece(lbIssue.Items[lbIssue.ItemIndex], '^', 2) + ' issue?', mtconfirmation, [mbYes, mbNo], 0) = mrNo then Exit;
  lbIssue.Items[lbIssue.ItemIndex] := lbIssue.Items[lbIssue.ItemIndex] + '^Inactive';
  Change := 1;
  btnIInact.Enabled := False;
end;

procedure TfrmSiteParam.lbTaskClick(Sender: TObject);
begin
  btnTEdit.Enabled  := True;
  btnTInact.Enabled := True;
end;

procedure TfrmSiteParam.btnTEditClick(Sender: TObject);
begin
  lblTSelect.Caption := 'Edit Task Name:';
  edTask.Text        := piece(lbTask.Items[lbTask.ItemIndex], '^', 2);
  cbTSpec.Text       := piece(lbTask.Items[lbTask.ItemIndex], '^', 3);
  Ttemp              := edTask.Text;
  Stemp              := cbTSpec.Text;
  TEdit              := 1;
  btnTAdd.Enabled    := False;
  btnTInact.Enabled  := False;
  DisplayTask;
end;

procedure TfrmSiteParam.btnTAddClick(Sender: TObject);
begin
  DisplayTask;
  btnTEdit.Enabled  := False;
  btnTInact.Enabled := False;
end;

procedure TfrmSiteParam.cbTSpecChange(Sender: TObject);
begin
  if cbTSpec.Text = '' then Exit;
  cbTSpec.DroppedDown := True;
  Change := 1;
end;

procedure TfrmSiteParam.btnTInactClick(Sender: TObject);
begin
  if MessageDlg('Are you sure you want to inactivate the' + CRLF +
    piece(lbTask.Items[lbTask.ItemIndex], '^', 2) + ' task?', mtconfirmation, [mbYes, mbNo], 0) = mrNo then Exit;
  lbTask.Items[lbTask.ItemIndex] := lbTask.Items[lbTask.ItemIndex] + '^Inactive';
  Change := 1;
  btnTInact.Enabled := False;
end;

procedure TfrmSiteParam.edTaskChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cbTSpecClick(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.btnIEditClick(Sender: TObject);
begin
  lblSelect.Caption := 'Edit Issue name:';
  edIssue.Text      := piece(lbIssue.Items[lbIssue.ItemIndex], '^', 2);
  Itemp             := edIssue.Text;
  IEdit             := 1;
  btnIAdd.Enabled   := False;
  btnIInact.Enabled := False;
  DisplayIssue;
end;

procedure TfrmSiteParam.btnSAddClick(Sender: TObject);
var
  Z: string;
begin
  Z := '';
  lblFSpec.Visible := True;
  cbFSpec.Visible  := True;
  CallV('APTWL GET SPEC', [0, Z, SiteIFN]);
  cbFSpec.Items := RPCBrokerV.Results;
end;

procedure TfrmSiteParam.cbFSpecClick(Sender: TObject);
begin
  lbFSpec.Items.Add(cbFSpec.Items[cbFSpec.ItemIndex]);
  CallV('APTWL PUT ASSIGNED SPEC', [lbFac.ItemIEN, lbFSpec.Items, SiteIFN]);
end;

procedure TfrmSiteParam.btnSDelClick(Sender: TObject);
var
  Success: string;
begin
  if MessageDlg('Are you sure you want to delete ' + piece(lbFSpec.Items[lbFSpec.ItemIndex], '^', 2) + '?',
    mtconfirmation, [mbYes, mbNo], 0) = mrNo then Exit;
  lbFSpec.Items.Delete(lbFSpec.ItemIndex);
  Success := sCallV('APTWL PUT ASSIGNED SPEC', [lbFac.ItemIEN, lbFSpec.Items, SiteIFN]);
  btnSDel.Enabled := False;
end;

procedure TfrmSiteParam.HideSSpec;
begin
  pnlSSel.Visible  := False;
end;

procedure TfrmSiteParam.DisplaySSpec;
begin
  pnlSSel.Visible  := True;
end;

procedure TfrmSiteParam.btnSpAddClick(Sender: TObject);
begin
  DisplaySSpec;
  btnSInact.Enabled := False;
end;

procedure TfrmSiteParam.lbSSpecClick(Sender: TObject);
begin
  btnSInact.Enabled := True;
end;

procedure TfrmSiteParam.cbSSpecChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.btnSInactClick(Sender: TObject);
begin
  if MessageDlg('Are you sure you want to inactivate ' + piece(lbSSpec.Items[lbSSpec.ItemIndex], '^', 2) + '?',
    mtConfirmation, [mbYes, mbNo], 0) = mrNo then Exit;
  lbSSpec.Items[lbSSpec.ItemIndex] := lbSSpec.Items[lbSSpec.ItemIndex] + '^Inactive';
  btnSInact.Enabled := False;
  Change := 1;
end;

procedure TfrmSiteParam.cbSServChange(Sender: TObject);
begin
  if cbSServ.Text = '' then Exit;
  CallV('APTWL GET SERVICE', [cbSServ.Text]);
  cbSServ.Items := RPCBrokerV.Results;
  cbSServ.DroppedDown := True;
end;

procedure TfrmSiteParam.btnSOKClick(Sender: TObject);
var
  data: string;
begin
  if (cbSSpec.Text = '') or (cbSServ.Text = '') then
    begin
      MessageDlg('Please select both specialty and service.', mtwarning, [mbOK], 0);
      Exit;
    end;
  data := IntToStr(cbSSpec.ItemIEN) + '^' + cbSSpec.Text + '^' + ServIFN + '^' + cbSServ.Text;
  lbSSpec.Items.Add(data);
  cbSSpec.Text := '';
  cbSServ.Text := '';
  HideSSpec;
end;

procedure TfrmSiteParam.btnSCancClick(Sender: TObject);
begin
  HideSSpec;
end;

procedure TfrmSiteParam.btnTCancClick(Sender: TObject);
begin
  edTask.Text := '';
  cbTSpec.Text := '';
  HideTask;
  btnTAdd.Enabled  := True;
  btnTEdit.Enabled := False;
  Exit;
end;

procedure TfrmSiteParam.btnTOKClick(Sender: TObject);
var
  Success: string;
begin
  if TEdit = 0 then
    begin
      if edTask.Text = '' then
        begin
          HideTask;
          Exit;
        end;
      Success := sCallV('APTWL PUT TASK LIST', [edTask.Text, cbTSpec.ItemIEN]);
      if Success = '0' then Exit;
      lbTask.Clear;
      CallV('APTWL GET TASK LIST', []);
      lbTask.Items := RPCBrokerV.Results;
      edTask.Text  := '';
      cbTSpec.Text := '';
    end;
  if TEdit = 1 then
    begin
      if (edTask.Text = Ttemp) and (cbTSpec.Text = Stemp) then  // no changes
        begin
          HideTask;
          Exit;
        end;
      lbTask.Items[lbTask.ItemIndex] := piece(lbTask.Items[lbTask.ItemIndex], '^', 1) + '^' + edTask.Text + '^' + cbTSpec.Text + '^Edited';
      lblTSelect.Caption := 'Enter New Task:';
      btnTEdit.Enabled  := False;
      TEdit  := 0;
    end;
  HideTask;
end;

procedure TfrmSiteParam.pcSiteChange(Sender: TObject);
var
  data: string;
begin
  with pcSite do
    begin
      if (ActivePage = TabSheet2) and (Tab2 = 0) then
        begin
          CallV('APTWL GET USERS', []);
          cbMUser.Items := RPCBrokerV.Results;
          Tab2 := 1;
        end;
      if (ActivePage = TabSheet3) and (Tab3 = 0) then
        begin
          CallV('APTWL GET USERS', []);
          cbFUser.Items := RPCBrokerV.Results;
          Tab3 := 1;
        end;
      if (ActivePage = TabSheet4) and (Tab4 = 0) then
        begin
          CallV('APTWL GET PROVIDER', ['G', 0]);
          cbAUser.Items := RPCBrokerV.Results;
          Tab4 := 1;
        end;
      {if (ActivePage = TabSheet5) and (Tab5 = 0) then
        begin
          Tab5 := 1;
        end;}
      if (ActivePage = TabSheet6) and (Tab6 = 0) then
        begin
          CallV('APTWL GET USE SPEC', [SiteIFN]);
          cbTSpec.Items := RPCBrokerV.Results;
          Tab6 := 1;
        end;
      if (ActivePage = TabSheet7) and (Tab7 = 0) then
        begin
          CallV('APTWL GET SPEC NAT', []);
          cbSSpec.Items := RPCBrokerV.Results;
          CallV('APTWL GET SERVICE', []);
          cbSServ.Items := RPCBrokerV.Results;
          Tab7 := 1;
        end;
      if (ActivePage = TabSheet8) and (Tab8 = 0) then
    end;
end;

procedure TfrmSiteParam.cb1Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb2Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb3Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb4Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb5Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb6Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb7Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb8Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb9Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb10Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb11Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb12Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb13Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb14Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb15Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb16Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb17Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb18Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb19Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb20Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb21Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb22Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb23Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb24Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb25Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb26Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb27Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb28Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb29Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cb30Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.cbSServClick(Sender: TObject);
begin
  ServIFN := IntToStr(cbSServ.ItemIEN);
  Change := 1;
end;

procedure TfrmSiteParam.cbAdminChange(Sender: TObject);
begin
  if cbAdmin.Text = '' then Exit;
  CallV('APTWL GET CANCEL REASON', [cbAdmin.Text]);
  cbAdmin.Items := RPCBrokerV.Results;
end;

procedure TfrmSiteParam.cbAdminClick(Sender: TObject);
begin
  AdmIFN := IntToStr(cbAdmin.ItemIEN);
  Change := 1;
end;

procedure TfrmSiteParam.cbDeceasedChange(Sender: TObject);
begin
  if cbDeceased.Text = '' then Exit;
  CallV('APTWL GET CANCEL REASON', [cbDeceased.Text]);
  cbDeceased.Items := RPCBrokerV.Results;
end;

procedure TfrmSiteParam.cbDeceasedClick(Sender: TObject);
begin
  DecIFN := IntToStr(cbDeceased.ItemIEN);
  Change := 1;
end;

procedure TfrmSiteParam.cbOutChange(Sender: TObject);
begin
  if cbOut.Text = '' then Exit;
  CallV('APTWL GET CANCEL REASON', [cbOut.Text]);
  cbOut.Items := RPCBrokerV.Results;
end;

procedure TfrmSiteParam.cbOutClick(Sender: TObject);
begin
  OutIFN := IntToStr(cbOut.ItemIEN);
  Change := 1;
end;

procedure TfrmSiteParam.edTimeChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSiteParam.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  ResetTimeOut;
end;

procedure TfrmSiteParam.cbFromChange(Sender: TObject);
begin
  if cbFrom.Text = '' then Exit;
  CallV('APTWL GET HOSP LOC', [cbFrom.Text]);
  cbFrom.Items := RPCBrokerV.Results;
end;

procedure TfrmSiteParam.cbFromClick(Sender: TObject);
begin
  FromIFN := IntToStr(cbFrom.ItemIEN);
  Change  := 1;
end;

procedure TfrmSiteParam.RequiredFields;
var
  data: string;
begin
  data := sCallV('APTWL GET REQUIRED', []);
  if piece(data, '^', 1) = '1' then cb1.Checked := True;
  if piece(data, '^', 2) = '1' then cb2.Checked := True;
  if piece(data, '^', 3) = '1' then cb3.Checked := True;
  if piece(data, '^', 4) = '1' then cb4.Checked := True;
  if piece(data, '^', 5) = '1' then cb5.Checked := True;
  if piece(data, '^', 6) = '1' then cb6.Checked := True;
  if piece(data, '^', 7) = '1' then cb7.Checked := True;
  if piece(data, '^', 8) = '1' then cb8.Checked := True;
  if piece(data, '^', 9) = '1' then cb9.Checked := True;
  if piece(data, '^', 10) = '1' then cb10.Checked := True;
  if piece(data, '^', 11) = '1' then cb11.Checked := True;
  if piece(data, '^', 12) = '1' then cb12.Checked := True;
  if piece(data, '^', 13) = '1' then cb13.Checked := True;
  if piece(data, '^', 14) = '1' then cb14.Checked := True;
  if piece(data, '^', 15) = '1' then cb15.Checked := True;
  if piece(data, '^', 16) = '1' then cb16.Checked := True;
  if piece(data, '^', 17) = '1' then cb17.Checked := True;
  if piece(data, '^', 18) = '1' then cb18.Checked := True;
  if piece(data, '^', 19) = '1' then cb19.Checked := True;
  if piece(data, '^', 20) = '1' then cb20.Checked := True;
  if piece(data, '^', 21) = '1' then cb21.Checked := True;
  if piece(data, '^', 22) = '1' then cb22.Checked := True;
  if piece(data, '^', 23) = '1' then cb23.Checked := True;
  if piece(data, '^', 24) = '1' then cb24.Checked := True;
  if piece(data, '^', 25) = '1' then cb25.Checked := True;
  if piece(data, '^', 26) = '1' then cb26.Checked := True;
  if piece(data, '^', 27) = '1' then cb27.Checked := True;
  if piece(data, '^', 28) = '1' then cb28.Checked := True;
  if piece(data, '^', 29) = '1' then cb29.Checked := True;
  if piece(data, '^', 30) = '1' then cb30.Checked := True;
end;

procedure TfrmSiteParam.HideIssue;
begin
  pnlISel.Visible := False;
  btnIEdit.Enabled := False;
  btnIAdd.Enabled  := True;
end;

procedure TfrmSiteParam.DisplayIssue;
begin
  pnlISel.Visible := True;
end;

procedure TfrmSiteParam.btnICancClick(Sender: TObject);
begin
  HideIssue;
end;

procedure TfrmSiteParam.btnIOKClick(Sender: TObject);
var
  Success: string;
begin
  if IEdit = 0 then
    begin
      if edIssue.Text = '' then
        begin
          HideIssue;
          Exit;
        end;
      Success := sCallV('APTWL PUT ISSUE LIST', [edIssue.Text]);
      if Success = '0' then Exit;
      lbIssue.Clear;
      CallV('APTWL GET ISSUE LIST', []);
      lbIssue.Items := RPCBrokerV.Results;
      edIssue.Text := '';
      Change := 1;
    end;
  if IEdit = 1 then
    begin
      if edIssue.Text = Itemp then  // no changes
        begin
          HideIssue;
          Exit;
        end;
      lbIssue.Items[lbIssue.ItemIndex] := piece(lbIssue.Items[lbIssue.ItemIndex], '^', 1) + '^' + edIssue.Text + '^Edited';
      lblSelect.Caption := 'Enter New Issue:';
      IEdit  := 0;
      Change := 1;
    end;
  HideIssue;
end;

procedure TfrmSiteParam.btnMCancClick(Sender: TObject);
begin
  HideMUser;
end;

procedure TfrmSiteParam.btnACancClick(Sender: TObject);
begin
  HideAUser;
end;

procedure TfrmSiteParam.lbFSpecClick(Sender: TObject);
begin
  btnSDel.Enabled := True;
end;

procedure TfrmSiteParam.cbConYClick(Sender: TObject);
begin
  if (cbConY.Checked = True) then cbConN.Checked := False;
end;

procedure TfrmSiteParam.cbConNClick(Sender: TObject);
begin
  if (cbConN.Checked = True) then cbConY.Checked := False;
end;

procedure TfrmSiteParam.cbLocYClick(Sender: TObject);
begin
  if (cbLocY.Checked = True) then cbLocN.Checked := False;
end;

procedure TfrmSiteParam.cbLocNClick(Sender: TObject);
begin
  if (cbLocN.Checked = True) then cbLocY.Checked := False;
end;

end.
